﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using UUN;
using System.Data.SqlClient;
using System.IO;

public partial class Admin_NeiRong_ZhuanJi_ZengJia : System.Web.UI.Page
{
    private 访问 访问;
    protected void Page_Load(object sender, EventArgs e)
    {
        访问 = new 访问(this.Context);
        访问.开始处理("增加专辑", "网站后台", "增加专辑", new 访问.回调委托(ZhiXing));
        访问.关闭连接();
    }

    private void ZhiXing()
    {
        访问.验证管理员();

        if (this.IsPostBack)
            增加专辑();
    }

    private void 增加专辑()
    {
        访问.验证权限("19");
        String 专辑名称 = ZhuanJiMingChen.Text;
        String 专辑封面;
        if (Request.Files.Count != 1)
            throw new Exception("必须上传专辑封面");
        int ZGID = 常用.SQL_最高ID(访问.连接, 程序.数据表前缀+"内容_音乐_专辑");
        String 存储文件夹 = 程序.安装位置 + "Data/DT_ZhuanJi/" + (ZGID /500) + "/";
        if (!Directory.Exists(Server.MapPath(存储文件夹)))
            Directory.CreateDirectory(Server.MapPath(存储文件夹));
        String 文件名 = "T" + ZGID + 常用.随机字符(30);
        if (Request.Files[0].ContentLength < 1)
            throw new Exception("专辑封面不能为空");
        String 后缀 = Path.GetExtension(Request.Files[0].FileName).Substring(1);
        if (!常用.是否允许后缀("gif,jpg,jpe,jpeg,png,tif,tiff,bmp", 后缀))
            throw new Exception("图片格式不正确");
        Request.Files[0].SaveAs(Server.MapPath(存储文件夹 + 文件名 + "." + 后缀));
        专辑封面 = 存储文件夹 + 文件名 + "." + 后缀;
        String 专辑歌手 = ZhuanJiGeShou.Text;
        String 专辑简介 = ZhuanJiJianJie.Text;

        if (专辑名称.Length < 1 || 专辑名称.Length > 50)
            throw new Exception("专辑名称的长度只能在1-50之间");
        if (专辑简介.Length < 1 || 专辑简介.Length > 4000)
            throw new Exception("专辑简介的长度只能在1-4000之间");


        SqlCommand 语句 = new SqlCommand("INSERT INTO [" + 程序.数据表前缀 + "内容_音乐_专辑]([ID],[专辑名称],[专辑封面],[专辑歌手],[专辑简介])" +
            "VALUES(@ID,@专辑名称,@专辑封面,@专辑歌手,@专辑简介)", 访问.连接);
        语句.Parameters.Add("@ID", SqlDbType.Int).Value = ZGID;
        语句.Parameters.Add("@专辑名称", SqlDbType.NVarChar).Value = 专辑名称;
        语句.Parameters.Add("@专辑封面", SqlDbType.NVarChar).Value = 专辑封面;
        语句.Parameters.Add("@专辑歌手", SqlDbType.NVarChar).Value = 专辑歌手;
        语句.Parameters.Add("@专辑简介", SqlDbType.NVarChar).Value = 专辑简介;
        语句.ExecuteNonQuery();
        访问统计_管理记录 记录 = new 访问统计_管理记录(this.Context, 访问.连接);
        记录.记录("增加专辑[" + 专辑名称 + "]", 访问.用户["昵称"].ToString());


        Response.Redirect("ZhuanJiGuanLi.aspx");
    }
}
